%Hauptpprogramm
% Unsere globalen Variable
global position vs UF m1 m2 m3 ms mt m0 P0 P gam t v0 AE ort0 startort...
   tmax getroffen zeitgetroffen ntime vfaktor vs nsonde minSM P0eingabe

%Startwerte
% Hier eingeben
% Einheiten:	
% Lnge:	1000km
% Zeit:		6 h
% Masse:	100 t

UF=1/21.600;  				%Geschwindigkeitsmastab
MF=1E-5;        			%Massenmastab
LF=1E-6;        			%Lngenmastab
TF=1/21600;      			%Zeitmastab 
PUF=MF*LF^2/TF^3*1000;	%Leistungsmastab
gam=-(LF^3/(MF*(TF.^2)))*6.673E-11;      %Gamma


m1=1.99*1E25;			%Sonnenmasse
m2=TF*5.97*1E19;		%Erdenmasse
m3=6.3879*1E18;			%Marsmasse
ms=4.8*1E-3;			%Sondenmasse
mt=8*1E-4;			%Treibstoffmasse
m0=ms+mt;			%Gesamtmasse der Sonde am Start
P0=P0eingabe*PUF/1000;			%Triebwerksleistung beim Start
AE=149597.870;
T=[0 0];

% X: Alle Koordinaten festlegen (Ort und v festlegen)

%Sonne
X(1:2)=0;	%Heliozentrisches System
X(3:4)=0;
%Erde
X(5:6)=[startort(1) startort(2)]; %Startort Erde
X(7:8)=[startort(3) startort(4)]; %Startgeschwindigekeit Erde
%Mars
X(9:10)=[startort(5) startort(6)]; 	%Startort Mars
X(11:12)=[startort(7) startort(8)]; %Startgeschwindigkeit Mars
%Sonde
sonde=startort(1:2)/norm(startort(1:2));
norm(sonde);
X(13:14)=startort(1:2)+sonde*nsonde*AE; %Abstand Erde Sonde beim Start 

dP=(startort(1:2))/(norm(startort(1:2)));

vec1=dP(1);
vec2=dP(2);
vec=[-vec2 vec1];

X(15:16)=vec*29.77/UF*vfaktor;
ort0=norm(X(5:6));					%Ausgangsort fr Leistungabhngigkeit

v0=sqrt(X(15).^2+X(16).^2);

t=[1:10:ntime];
tmax=ntime;

% ODe-Solver aufrufen
[T,position,S]=ode113('derivs',t,X);

if(getroffen==1)
   title(strcat('Der Mars wurde nach #',int2str(round(zeitgetroffen)),'# Tagen getroffen'));
else
   title('Der Mars wurde in der vorgegebenen Zeit nicht getroffen');
end
